<?php
/**
 * BoostonCP WHMCS Hooks - STABLE SECTION INJECTION
 */

use Illuminate\Database\Capsule\Manager as Capsule;

add_hook('AdminAreaFooterOutput', 1, function($vars) {
    if ($vars['filename'] !== 'clientsservices') return '';

    $serviceId = (int)$_REQUEST['id'];
    if (!$serviceId) return '';

    // Verify BoostonCP service
    try {
        $service = Capsule::table('tblhosting')->where('id', $serviceId)->first();
        $product = Capsule::table('tblproducts')->where('id', $service->packageid)->first();
        if ($product->servertype !== 'boostoncp') return '';
    } catch (\Exception $e) { return ''; } // Corrected escaping for \Exception

    $userLoginUrl = "modules/servers/boostoncp/redirect.php?id=" . $serviceId;
    $adminLoginUrl = "modules/servers/boostoncp/redirect.php?id=" . $serviceId . "&type=admin";

    return "\n    <script type='text/javascript'>\n    $(document).ready(function() {\n        // Find the 'Module Commands' row in the service details table\n        var cmdRow = $('.fieldlabel:contains(\"Module Commands\")').closest('tr');\n        \n        if (cmdRow.length && $('#booston-admin-section').length === 0) {\n            var html = '<tr id=\"booston-admin-section\">' +\n                '<td class=\"fieldlabel\">BoostonCP Access</td>' +\n                '<td class=\"fieldarea\">' +\n                '<div style=\"display:flex; gap:10px; align-items:center;\">' +\n                '<a href=\"" . $userLoginUrl . "\" target=\"_blank\" class=\"btn btn-primary\" style=\"background: linear-gradient(135deg, #0061ff 0%, #60efff 100%) !important; border:none; font-weight:bold; color:white !important; padding:5px 15px;\"><i class=\"fas fa-user-shield\"></i> Login to User Account</a>' +\n                '<a href=\"" . $adminLoginUrl . "\" target=\"_blank\" class=\"btn btn-dark\" style=\"background:#1e293b; border:none; font-weight:bold; color:white !important; padding:5px 15px;\"><i class=\"fas fa-tools\"></i> Master Admin</a>' +\n                '</div>' +\n                '</td>' +\n                '</tr>';\n            \n            cmdRow.after(html);\n        }\n    });\n    </script>";
});
?>