<?php
/**
 * BoostonCP Global Hooks - PLACE THIS IN /includes/hooks/
 */

use Illuminate\Database\Capsule\Manager as Capsule;

add_hook('AdminAreaFooterOutput', 1, function($vars) {
    if ($vars['filename'] !== 'clientsservices') return '';

    $serviceId = (int)$_REQUEST['id'];
    if (!$serviceId) return '';

    // Verify if it is a BoostonCP service
    try {
        $service = Capsule::table('tblhosting')
            ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
            ->where('tblhosting.id', $serviceId)
            ->select('tblproducts.servertype')
            ->first();

        if (!$service || $service->servertype !== 'boostoncp') return '';
    } catch (\Exception $e) { return ''; } // Corrected: Escaped backslash for exception class name

    $loginUrl = "modules/servers/boostoncp/redirect.php?id=" . $serviceId;

    return "
    <script type='text/javascript'>
    $(document).ready(function() {
        // Target the main action container
        var btnBar = $('.context-btn-container');
        if (btnBar.length === 0) btnBar = $('.module-buttons');

        if (btnBar.length) {
            var buttons = '<div style=\"display:inline-flex; gap:10px; margin-right:15px; vertical-align:middle;\">' + // Corrected: Escaped double quotes within the style attribute
                '<a href=\"" . $loginUrl . "\" target=\"_blank\" class=\"btn btn-primary\" style=\"background: linear-gradient(135deg, #0061ff 0%, #60efff 100%) !important; border:none !important; font-weight:800 !important; color:white !important; border-radius:4px !important; padding:7px 15px !important; box-shadow: 0 4px 10px rgba(0, 97, 255, 0.3) !important;\">' + // Corrected: Escaped double quotes within the style attribute and href/target attributes
                '<i class=\"fas fa-bolt\"></i> LOGIN TO PANEL</a>' + // Corrected: Escaped double quotes within the class attribute
                '</div>';
            
            btnBar.prepend(buttons);
        }
    });
    </script>";
});
?>