<?php
/**
 * BoostonCP WHMCS Server Module
 * Version: 1.6.0 (Stable)
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use Illuminate\Database\Capsule\Manager as Capsule;

function boostoncp_MetaData() {
    return array(
        'DisplayName' => 'BoostonCP',
        'APIVersion' => '1.1',
        'RequiresServer' => true,
    );
}

function boostoncp_ConfigOptions($params) {
    $packages = array("" => "-- Select Package --");
    $host = $params['serverhostname'] ? $params['serverhostname'] : $params['serverip'];
    $apiKey = $params['serveraccesshash'];

    if (empty($host) || empty($apiKey)) {
        try {
            $serverId = 0;
            if (isset($_REQUEST['servergroup']) && $_REQUEST['servergroup'] > 0) {
                $serverRel = Capsule::table('tblservergroupsrel')->where('groupid', $_REQUEST['servergroup'])->first();
                if ($serverRel) $serverId = $serverRel->serverid;
            } elseif (isset($_REQUEST['server']) && $_REQUEST['server'] > 0) {
                $serverId = $_REQUEST['server'];
            }
            if ($serverId > 0) {
                $server = Capsule::table('tblservers')->where('id', $serverId)->first();
                if ($server) {
                    $params['serverip'] = $server->ipaddress;
                    $params['serverhostname'] = $server->hostname;
                    $params['serveraccesshash'] = $server->accesshash;
                    $params['serversecure'] = $server->secure;
                }
            }
        } catch (\Exception $e) { } // phpcs:ignore Generic.CodeAnalysis.EmptyStatement.DetectedDuringDeprecationAnalysis
    }

    $result = boostoncp_call_api($params, 'list_packages');
    if (isset($result['status']) && $result['status'] === 'success' && is_array($result['packages'])) {
        foreach ($result['packages'] as $pkg) {
            $packages[$pkg['id']] = $pkg['name'];
        }
    }

    return array(
        "package_id" => array(
            "FriendlyName" => "BoostonCP Package",
            "Type" => "dropdown",
            "Options" => $packages,
            "Description" => "Select the BoostonCP hosting plan.",
        ),
        "client_template" => array(
            "FriendlyName" => "Client Area Design",
            "Type" => "dropdown",
            "Options" => array(
                "premium_blue_design" => "Premium Blue (Modern - Default)",
                "original_design" => "BoostonCP (Original)",
                "alien_neon_design" => "Interstellar (Alien Neon)",
            ),
            "Default" => "premium_blue_design",
            "Description" => "Choose the look of the client dashboard.",
        ),
    );
}

function boostoncp_call_api($params, $action, $postData = array()) {
    $host = $params['serverhostname'] ? $params['serverhostname'] : $params['serverip'];
    $port = $params['serverport'] ? $params['serverport'] : '2087';
    $protocol = 'https';
    $apiKey = trim($params['serveraccesshash']);

    if (empty($apiKey)) return array('status' => 'error', 'message' => 'Missing API Key');

    $url = "$protocol://$host:$port/api/whmcs.php?action=$action&api_key=" . urlencode($apiKey);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
    curl_setopt($ch, CURLOPT_USERAGENT, 'BoostonCP-API');

    if (!empty($postData)) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    }

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($error) return array('status' => 'error', 'message' => "CURL Error: $error");
    $decoded = json_decode($response, true);
    return is_array($decoded) ? $decoded : array('status' => 'error', 'message' => 'Invalid Response');
}

function boostoncp_TestConnection($params) {
    $result = boostoncp_call_api($params, 'test');
    if ($result['status'] === 'success') {
        $msg = "CONNECTION SUCCESSFUL!\n\nHOSTNAME: " . ($result['hostname'] ?? 'N/A') . "\n";
        if (!empty($result['nameservers'])) {
            $msg .= "NS1: " . ($result['nameservers'][0] ?? 'N/A') . "\nNS2: " . ($result['nameservers'][1] ?? 'N/A');
        }
        return array('success' => true, 'message' => $msg);
    }
    return array('error' => $result['message']);
}

function boostoncp_CreateAccount($params) {
    $postData = array('username' => $params['username'], 'password' => $params['password'], 'email' => $params['clientsdetails']['email'], 'domain' => $params['domain'], 'package_id' => $params['configoption1']);
    $result = boostoncp_call_api($params, 'create', $postData);
    return ($result['status'] === 'success') ? 'success' : $result['message'];
}

function boostoncp_SuspendAccount($params) {
    $result = boostoncp_call_api($params, 'suspend', array('username' => $params['username']));
    return ($result['status'] === 'success') ? 'success' : $result['message'];
}

function boostoncp_UnsuspendAccount($params) {
    $result = boostoncp_call_api($params, 'unsuspend', array('username' => $params['username']));
    return ($result['status'] === 'success') ? 'success' : $result['message'];
}

function boostoncp_TerminateAccount($params) {
    $result = boostoncp_call_api($params, 'terminate', array('username' => $params['username']));
    return ($result['status'] === 'success') ? 'success' : $result['message'];
}

function boostoncp_AdminCustomButtonArray() {
    return array("Re-sync Resources" => "ResyncResources");
}

function boostoncp_ResyncResources($params) {
    $result = boostoncp_call_api($params, 'resync', array('username' => $params['username']));
    return ($result['status'] === 'success') ? 'success' : $result['message'];
}

function boostoncp_ClientArea($params) {
    try {
        $result = boostoncp_call_api($params, 'user_login', array('username' => $params['username']));
        $loginUrl = ($result['status'] === 'success') ? $result['login_url'] : '#';
        $template = !empty($params['configoption2']) ? $params['configoption2'] : 'premium_blue_design';
        return array('templatefile' => $template, 'vars' => array('login_url' => $loginUrl, 'api_error' => ($result['status'] !== 'success' ? $result['message'] : ''), 'domain' => $params['domain'], 'serverip' => $params['serverip']));
    } catch (\Exception $e) { return ""; } // phpcs:ignore Generic.CodeAnalysis.EmptyStatement.DetectedDuringDeprecationAnalysis
}

function boostoncp_AdminLink($params) {
    return "";
}
?>
